% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_twal_file.R
\name{create_twal_file}
\alias{create_twal_file}
\title{Simulates a twin DNA alignment and saves it to a FASTA file.}
\usage{
create_twal_file(twin_phylogeny, alignment_params, twinning_params)
}
\arguments{
\item{twin_phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}

\item{twinning_params}{can be \code{NA} if no twinning is desired,
or can be the twinning parameters,
as can be created by \link{create_twinning_params}}
}
\value{
nothing
}
\description{
The simulation is performed by \link{sim_twin_alignment}.
}
\examples{
# Check cleanup by other functions
beastier::check_empty_beaustier_folders()

# Create a true phylogeny to simulate the DNA sequences on
n_taxa <- 5
set.seed(1)
phylogeny <- ape::rcoal(n_taxa)

# Create the ancestor's DNA sequence
n_base_pairs <- 4
root_sequence <- create_blocked_dna(length = n_base_pairs)

# Simulate and save the true alignment
alignment_params <- create_alignment_params(
  root_sequence = root_sequence
)
create_tral_file(
  phylogeny = phylogeny,
  alignment_params = alignment_params
)

# Create a twin phylogeny to simulate the DNA sequences on
set.seed(2)
twin_phylogeny <- ape::rcoal(n_taxa)

# File does not exist yet
twinning_params <- create_twinning_params()

# Simulate and save the twin alignment
alignment <- create_twal_file(
 twin_phylogeny = twin_phylogeny,
 alignment_params = alignment_params,
 twinning_params = twinning_params
)

# File is at twinning_params$twin_alignment_filename

# Cleanup
beastier::remove_beaustier_folders()
beastier::check_empty_beaustier_folders()
}
\seealso{
Use \link{sim_twin_alignment} to only simulate
  the twin alignment, without saving the alignment to file
}
\author{
Richèl J.C. Bilderbeek
}
