% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_generative_trees.R
\name{create_yule_tree}
\alias{create_yule_tree}
\title{Create a Yule tree.}
\usage{
create_yule_tree(n_taxa = 6, crown_age = 10, n_0 = 2)
}
\arguments{
\item{n_taxa}{number of tree tips}

\item{crown_age}{the fixed crown age of the posterior. Set to NA
to let it be estimated}

\item{n_0}{number of starting species}
}
\value{
a phylogenetic tree of type \link[ape]{phylo}
}
\description{
A Yule model is also known as a pure-birth model;
a birth-death model without extinction.
}
\examples{
n_taxa <- 31
crown_age <- 41

create_yule_tree(
  n_taxa = 31,
  crown_age = 41
)
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
