% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_get.R
\name{pin_get}
\alias{pin_get}
\title{Retrieve a pin (legacy API)}
\usage{
pin_get(
  name,
  board = NULL,
  cache = TRUE,
  extract = NULL,
  version = NULL,
  files = FALSE,
  signature = NULL,
  ...
)
}
\arguments{
\item{name}{The name of the pin.}

\item{board}{The board where this pin will be retrieved from.}

\item{cache}{Should the pin cache be used? Defaults to \code{TRUE}.}

\item{extract}{Should compressed files be extracted? Each board defines the
default behavior.}

\item{version}{The version of the dataset to retrieve, defaults to latest one.}

\item{files}{Should only the file names be returned?}

\item{signature}{Optional signature to validate this pin, use \code{pin_info()}
to compute signature.}

\item{...}{Additional parameters.}
}
\description{
Retrieves a pin by name from the local or given board.
}
\details{
\code{pin_get()} retrieves a pin by name and, by default, from the local board.
You can use the \code{board} parameter to specify which board to retrieve a pin from.
If a board is not specified, it will use \code{pin_find()} to find the pin across
all boards and retrieve the one that matches by name.
}
\examples{
# define temporary board
board <- legacy_temp()
pin(mtcars, board = board)

# retrieve the mtcars pin
pin_get("mtcars", board = board)
}
