% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_s3}
\alias{board_register_s3}
\title{Register S3 Board}
\usage{
board_register_s3(
  name = "s3",
  bucket = Sys.getenv("AWS_BUCKET"),
  key = Sys.getenv("AWS_ACCESS_KEY_ID"),
  secret = Sys.getenv("AWS_SECRET_ACCESS_KEY"),
  cache = board_cache_path(),
  host = "s3.amazonaws.com",
  ...
)
}
\arguments{
\item{name}{Optional name for this board, defaults to 's3'.}

\item{bucket}{The name of the Amazon S3 bucket. Defaults to the \code{AWS_BUCKET} environment
variable.}

\item{key}{The key of the Amazon S3 bucket. Defaults to the \code{AWS_ACCESS_KEY_ID} environment
variable.}

\item{secret}{The secret of the Amazon S3 bucket. Defaults to the \code{AWS_SECRET_ACCESS_KEY} environment
variable.}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{host}{The host to use for storage, defaults to \code{"s3.amazonaws.com"}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register an Amazon S3 bucket as a board.
}
\details{
This function requires an Amazon S3 bucket to be manually created; otherwise,
registering an S3 board will fail.
}
\examples{
\dontrun{
# the following example requires an Amazon S3 API key
board_register_s3(bucket = "s3bucket")
}
}
\seealso{
board_register
}
