% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.pim.env.R
\docType{methods}
\name{new.pim.env}
\alias{new.pim.env}
\alias{new.pim.env,ANY-method}
\alias{new.pim.env,data.frame-method}
\alias{new.pim.env,environment-method}
\alias{new.pim.env,list-method}
\alias{new.pim.env,missing-method}
\title{Constructor for a pim.environment}
\usage{
new.pim.env(data, ...)

\S4method{new.pim.env}{missing}(data, ...)

\S4method{new.pim.env}{environment}(data, compare = "unique",
  env = parent.frame(), vars = NULL, classes = NULL, ...)

\S4method{new.pim.env}{list}(data, compare = "unique", vars = NULL, ...)

\S4method{new.pim.env}{data.frame}(data, compare = "unique", vars = NULL,
  ...)

\S4method{new.pim.env}{ANY}(data, ...)
}
\arguments{
\item{data}{a data frame, a list or an environment containing
the data for a probabilistic index model.}

\item{...}{extra parameters for construction of the poset, like
the argument \code{compare} from \code{\link{new.pim.poset}}.}

\item{compare}{a character vector, matrix or list that defines how the
set of pseudo observations (poset) should be constructed. 
if set to \code{NULL}, no poset is constructed.
See also \code{\link{new.pim.poset}} 
for more information on how to specify a custom poset.}

\item{env}{an environment that is the parent environment of the object.}

\item{vars}{An optional character vector with the names of the variables
that should be included in the pim environment. Note that the
variable names should be found in the object passed to argument \code{data}.}

\item{classes}{An optional character vector with the classes of the 
variables in the environment, given in the same order as 
the argument \code{data.names}.}
}
\value{
an object of the class \code{\link{pim.environment}}
}
\description{
This functions serves as a constructor for an object of the class
\code{\link{pim.environment}}. In most cases, calling this function directly
is not necessary.
}
\details{
This function is called during the preparation of the model
matrix for a pim. The resulting object is used to evaluate the formula
of a pim, and stores information on how this is done. 

Note that the parent of the environment is actually the 
\code{\link{pim.poset}} object in the \code{poset} slot. 
The parent you set using the \code{env} argument, 
is the parent of the \code{pim.poset} object.  This ensures that
when a formula is evaluated in the \code{pim.environment} it 
will use a suitable search path to find all functions and objects.
}
\examples{
new.pim.env() # Creates an empty object

# Starting from a data frame
data(DysData)
env1 <- new.pim.env(DysData)

env2 <- new.pim.env(DysData, compare=NULL)
poset(env2)
env3 <- new.pim.env(DysData, compare="all")
poset(env3)


data(FEVData)
env4 <- new.pim.env(FEVData, vars=c('Age','Sex'))
ls(env4)


}

