% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paf_confidence_one_to_one.R
\name{paf.confidence.one2one}
\alias{paf.confidence.one2one}
\title{Approximate Confidence Intervals for the Population Attributable 
  Fraction with one to one expected value of RR function, and unidimensional
  theta values}
\usage{
paf.confidence.one2one(X, thetahat, rr, thetalow, thetaup,
  weights = rep(1/nrow(as.matrix(X)), nrow(as.matrix(X))), confidence = 95,
  confidence_theta = 99, check_thetas = TRUE, deriv.method.args = list(),
  deriv.method = c("Richardson", "complex"), method = c("empirical",
  "approximate"), Xvar = var(X), check_exposure = TRUE, check_rr = TRUE,
  check_integrals = TRUE)
}
\arguments{
\item{X}{Random sample (\code{data.frame}) which includes exposure
and covariates.}

\item{thetahat}{Estimative of \code{theta} for the Relative Risk function}

\item{rr}{Function for Relative Risk which uses parameter 
\code{theta}. The order of the parameters shound be \code{rr(X, theta)}.


**Optional**}

\item{thetalow}{Lower bound of the confidence interval.}

\item{thetaup}{Upper bound of the confidence interval.}

\item{weights}{Survey \code{weights} for the random sample \code{X}.}

\item{confidence}{Confidence level \% (default: \code{95})}

\item{confidence_theta}{Confidence level \% of \code{theta} corresponding to
the interval [\code{thetalow}, \code{thetaup}] (default: \code{99}\%).}

\item{check_thetas}{Check that thetas are correctly specified}

\item{deriv.method.args}{\code{method.args} for 
\code{\link[numDeriv]{hessian}}.}

\item{deriv.method}{\code{method} for \code{\link[numDeriv]{hessian}}. 
Don't change this unless you know what you are doing.}

\item{method}{Either \code{"empirical"} (default) or \code{"approximate"}.}

\item{Xvar}{Variance of exposure levels (for \code{"approximate"}
method).}

\item{check_exposure}{Check that exposure \code{X} is positive and numeric}

\item{check_rr}{Check that Relative Risk function \code{rr} equals 
\code{1} when evaluated at \code{0}}

\item{check_integrals}{Check that counterfactual and relative risk's expected
values are well defined for this scenario}
}
\description{
Function that calculates approximate confidence intervals of the
  Population Attributable Fraction \code{\link{paf}} considering a one to one
  Relative Risk \code{rr} with unidimensional \code{theta} parameter values
}
\examples{

#Example 1: Exponential Relative Risk
#--------------------------------------------
set.seed(18427)
X <- data.frame(rnorm(1000, 3,.7))
thetahat <- 0.4
thetalow <- 0.1
thetaup  <- 0.7
paf.confidence.one2one(X, thetahat, function(X, theta){exp(theta*X)}, 
thetalow, thetaup)

#Approximate method:
Xmean <- data.frame(mean(X[,1]))
Xvar  <- var(X[,1])
paf.confidence.one2one(Xmean, thetahat, function(X, theta){exp(theta*X)}, 
thetalow, thetaup, Xvar = Xvar, method = "approximate")

#Example 2: Multivariate example
#--------------------------------------------
set.seed(18427)
X1 <- rnorm(1000,3,.7)
X2 <- rnorm(1000,3,.7)
X  <- data.frame(X1,X2)
thetahat <- c(0.12, 0.03)
thetalow <- c(0.05, 0.01)
thetaup  <- c(0.25, 0.06)
rr <- function(X, theta){exp(theta[1]*X[,1] + theta[2]*X[,2])}
paf.confidence.one2one(X, thetahat, rr, thetalow, thetaup) 

#Approximate method:
Xmean <- data.frame(t(colMeans(X)))
Xvar  <- var(X)
paf.confidence.one2one(Xmean, thetahat, 
function(X, theta){exp(theta[1]*X[,1] + theta[2]*X[,2])}, 
thetalow, thetaup, 
Xvar = Xvar, method = "approximate")

}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
