% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_taxonomy.R
\name{read_taxonomy}
\alias{read_taxonomy}
\title{Read in taxonomy files}
\usage{
read_taxonomy(file)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector) containing the
sequence id and the taxonomy information for each sequence.

Files ending in .gz, .bz2, .xz, or .zip will be automatically uncompressed.
Files starting with \verb{http://}, \verb{https://}, \verb{ftp://}, or \verb{ftps://} will be
automatically downloaded. Remote gz files can also be autom downloaded and
decompressed.}
}
\value{
A data frame with two columns. The \code{id} column contains a name for each
sequence and the \code{taxonomy} column, which contains the taxonomy for each
sequence. The string in the \code{taxonomy} column is a series of taxonomic names
separated by semi-colons. The string does not have a semi-colon at the end of
the sequence
}
\description{
Read a
\href{https://mothur.org/wiki/taxonomy_file/}{mothur-formatted taxonomy file}
into R as a data frame
}
\note{
There are no checks to insure that each sequence has a unique id value. It is
also assumed that each sequence has the same number of taxonomic levels
represented in the second column of the input file.
}
\examples{
temp <- tempfile()
write("seqA\tA;B;C;", file = temp)
write("seqB\tA;B; C;", file = temp, append = TRUE)
write("seqC\tA; B;C;", file = temp, append = TRUE)
write("seqD\tA;B;C", file = temp, append = TRUE)
write("seqE\tA;B; C", file = temp, append = TRUE)
write("seqF\tA; B;C", file = temp, append = TRUE)
write("seq G\tA;B;C;", file = temp, append = TRUE)

read_taxonomy(temp)
}
