% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage1.R
\name{taxise_run}
\alias{taxise_run}
\title{Run taxise stage}
\usage{
taxise_run(wd)
}
\arguments{
\item{wd}{Working directory}
}
\description{
Run the first stage of phylotaR, taxise. This looks up
all descendant taxonomic nodes for a given taxonomic ID. It then
looks up relevant taxonomic information and generates a taxonomic
dictionary for user interaction after phylotaR has completed.
}
\details{
Objects will be cached.
}
\examples{
\dontrun{
  
  # Note: this example requires BLAST and internet to run.
  
  # example with temp folder
  wd <- file.path(tempdir(), 'aotus')
  # setup for aotus, make sure aotus/ folder already exists
  if (!dir.exists(wd)) {
    dir.create(wd)
  }
  ncbi_dr <- '[SET BLAST+ BIN PATH HERE]'
  setup(wd = wd, txid = 9504, ncbi_dr = ncbi_dr)  # txid for Aotus primate genus
  # individually run stages
  taxise_run(wd = wd)
}
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{ClstrRec-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}
}
