% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\docType{class}
\name{ClstrRec-class}
\alias{ClstrRec-class}
\alias{ClstrRec-method}
\alias{as.character,ClstrRec-method}
\alias{show,ClstrRec-method}
\alias{print,ClstrRec-method}
\alias{str,ClstrRec-method}
\alias{summary,ClstrRec-method}
\title{Cluster record}
\usage{
\S4method{as.character}{ClstrRec}(x)

\S4method{show}{ClstrRec}(object)

\S4method{print}{ClstrRec}(x)

\S4method{str}{ClstrRec}(object, max.level = 2L, ...)

\S4method{summary}{ClstrRec}(object)
}
\arguments{
\item{x}{\code{ClstrRec} object}

\item{object}{\code{ClstrRec} object}

\item{max.level}{Maximum level of nesting for str()}

\item{...}{Further arguments for str()}
}
\description{
Cluster record contains all information on a cluster.
}
\section{Slots}{

\describe{
\item{\code{id}}{Cluster ID, integer}

\item{\code{sids}}{Sequence IDs}

\item{\code{nsqs}}{Number of sequences}

\item{\code{txids}}{Source txids for sequences}

\item{\code{ntx}}{Number of taxa}

\item{\code{typ}}{Cluster type: direct, subtree or merged}

\item{\code{seed}}{Seed sequence ID}

\item{\code{prnt}}{Parent taxonomic ID}
}}

\examples{
data('aotus')
clstrrec <- aotus@clstrs@clstrs[[1]]
# this is a ClstrRec object
# it contains cluster information
show(clstrrec)
# you can access its different data slots with @
clstrrec@id     # cluster id
clstrrec@sids   # sequence IDs
clstrrec@nsqs   # number of sequences
clstrrec@txids  # taxonomic IDs of sequences
clstrrec@ntx    # number unique taxonomic IDs
clstrrec@typ    # cluster type: merged, subtree, direct or paraphyly
clstrrec@prnt   # MRCA of all taxa
clstrrec@seed   # most inter-connected sequence
}
\seealso{
Other run-public: \code{\link{ClstrArc-class}},
  \code{\link{Phylota-class}}, \code{\link{SeqArc-class}},
  \code{\link{SeqRec-class}}, \code{\link{TaxDict-class}},
  \code{\link{TaxRec-class}}, \code{\link{clusters2_run}},
  \code{\link{clusters_run}},
  \code{\link{parameters_reset}}, \code{\link{reset}},
  \code{\link{restart}}, \code{\link{run}},
  \code{\link{setup}}, \code{\link{taxise_run}}
}
