% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloSignalExtra.R
\name{phyloSignalBS}
\alias{phyloSignalBS}
\title{Computes phylogenetic signal for bootstrapped replicates of a phylogeny.}
\usage{
phyloSignalBS(p4d, multiphylo, methods = c("all", "I", "Cmean", "Lambda", "K",
  "K.star"), reps = 999, W = NULL, pb = TRUE)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{multiphylo}{a \code{multiphylo} object containing bootstrapped trees of \code{p4d}.}

\item{methods}{a character vector giving the methods to compute phylogenetic signal (see \code{\link{phyloSignal}}).}

\item{reps}{an integer. The number of repetitions for the estimation of p.values with randomization.}

\item{W}{an optional matrix of phylogenetic weights to compute Moran's I. By default the matrix
is computed with the function \code{\link[adephylo]{proxTips}} with patristic distances.}

\item{pb}{a logical. Should a progress bar be printed? (default \code{TRUE}).}
}
\value{
The data generated are returned invisibly as a list.
}
\description{
This function computes phylogenetic signal statistics and p-values
for bootsrapped replicates a phylogenetic tree and produce boxplots to represent the results.
This can be useful to check the impact of phylogenetic reconstruction uncertainty on phylogenetic signal.
}
\details{
Time consumption can be important if there are many bootraped trees and tested traits.
}
