# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes permutation test for Moran's I
#' 
#' @param xr a vector of data
#' @param Wr a weighting matrix
#' @param reps the number of permutations
moranTest <- function(xr, Wr, reps) {
    .Call('phylosignal_moranTest', PACKAGE = 'phylosignal', xr, Wr, reps)
}

#' Computes permutation test for Blomberg's K
#' 
#' @param xr a vector of data
#' @param vcvr phylogenetic variance-covariance matrix
#' @param reps the number of permutations
kTest <- function(xr, vcvr, reps) {
    .Call('phylosignal_kTest', PACKAGE = 'phylosignal', xr, vcvr, reps)
}

#' Computes permutation test for Blomberg's K Star
#' 
#' @param xr a vector of data
#' @param vcvr phylogenetic variance-covariance matrix
#' @param reps the number of permutations
kStarTest <- function(xr, vcvr, reps) {
    .Call('phylosignal_kStarTest', PACKAGE = 'phylosignal', xr, vcvr, reps)
}

#' Computes log-likelihood for data and a given value of Pagel's Lambda
#' 
#' @param lambda the value of Pagel's Lambda
#' @param xr a vector of data
#' @param vcvr phylogenetic variance-covariance matrix
#' 
#' @author Adapted from Liam Revell's R function 'phylosig' {phytools}.
pagelLogLik <- function(lambda, xr, vcvr) {
    .Call('phylosignal_pagelLogLik', PACKAGE = 'phylosignal', lambda, xr, vcvr)
}

#' Mantel statistic
#' 
#' @param xr a matrix of traits.
#' @param Wr a matrix of weights.
mantelStat <- function(xr, Wr) {
    .Call('phylosignal_mantelStat', PACKAGE = 'phylosignal', xr, Wr)
}

