% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot.R
\name{coef_plot}
\alias{coef_plot}
\title{Plot path coefficients and their confidence intervals.}
\usage{
coef_plot(fitted_DAG, reverse_order = FALSE)
}
\arguments{
\item{fitted_DAG}{A fitted DAG, usually obtained by \code{best},
\code{average} or \code{est_DAG}.}

\item{reverse_order}{If \code{TRUE}, the paths are plotted in reverse order.
Particularly useful in combination with \code{ggplot2::coor_flip} to create
horizontal versions of the plot.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot path coefficients and their confidence intervals.
}
\examples{
  d <- DAG(LS ~ BM, NL ~ BM, DD ~ NL + LS)
  plot(d)
  d_fitted <- est_DAG(d, rhino, ape::corBrownian, rhino_tree)
  plot(d_fitted)
  coef_plot(d_fitted)
  # to create a horizontal version, use this:
  coef_plot(d_fitted, reverse_order = TRUE) + ggplot2::coord_flip()
}
