% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtr.R
\name{qtr}
\alias{qtr}
\alias{qtr_end}
\alias{qtr_next}
\alias{qtr_prev}
\title{Assign a date to a quarter}
\usage{
qtr(date, format = c("long", "short"))

qtr_end(date, format = c("long", "short"))

qtr_next(date, format = c("long", "short"))

qtr_prev(date, format = c("long", "short"))
}
\arguments{
\item{date}{A date which must be supplied with \code{Date} or \code{POSIXct}}

\item{format}{A \code{character} string specifying the format the quarter
should be displayed in. Valid options are \code{long} (January to March 2018) and
\code{short} (Jan-Mar 2018). The default is \code{long}.}
}
\value{
A character vector of financial quarters in the specified format.
}
\description{
The qtr functions take a date input and calculate the relevant
quarter-related value from it. They all return the year as part of this
value.

\itemize{
\item \code{qtr} returns the current quarter

\item \code{qtr_end} returns the last month in the quarter

\item \code{qtr_next} returns the next quarter

\item \code{qtr_prev} returns the previous quarter
}
}
\details{
Quarters are defined as:

\itemize{
\item January to March (Jan-Mar)
\item April to June (Apr-Jun)
\item July to September (Jul-Sep)
\item October to December (Oct-Dec)
}
}
\examples{
x <- lubridate::dmy(c(26032012, 04052012, 23092012))
qtr(x)
qtr_end(x, format = "short")
qtr_next(x)
qtr_prev(x, format = "short")

}
