% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bake.R
\encoding{UTF-8}
\name{bake}
\alias{bake}
\alias{temp_resp1}
\alias{temp_resp2}
\title{Leaf parameter temperature responses}
\usage{
bake(leaf_par, bake_par, constants, assert_units = TRUE)

temp_resp1(par25, E_a, R, T_leaf, T_ref, unitless)

temp_resp2(par25, D_s, E_a, E_d, R, T_leaf, T_ref, unitless)
}
\arguments{
\item{leaf_par}{A list of leaf parameters inheriting class \code{leaf_par}. This can be generated using the \code{make_leafpar} function.}

\item{bake_par}{A list of temperature response parameters inheriting class \code{bake_par}. This can be generated using the \code{make_bakepar} function.}

\item{constants}{A list of physical constants inheriting class \code{constants}. This can be generated using the \code{make_constants} function.}

\item{assert_units}{Logical. Should parameter \code{units} be checked? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}

\item{par25}{Parameter value at 25 °C of class \code{units}.}

\item{E_a}{Empirical temperature response value in J/mol of class \code{units}.}

\item{R}{Ideal gas constant in J / (mol K) of class \code{units}. See \code{\link{make_constants}}.}

\item{T_leaf}{Leaf temperature in K of class \code{units}. Will be converted to °C.}

\item{T_ref}{Reference temperature in K of class \code{units}.}

\item{unitless}{Logical. Should \code{units} be set? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}

\item{D_s}{Empirical temperature response value in J / (mol K) of class \code{units}.}

\item{E_d}{Empirical temperature response value in J/mol of class \code{units}.}
}
\description{
'bake' leaf parameters using temperature response functions

Constructor function for \code{baked} class. This will also inherit class \code{\link{leaf_par}}. This function ensures that temperature is "baked in" to leaf parameter calculations \code{T_leaf} using temperature response functions detailed below.
}
\details{
Several leaf parameters (\code{\link{leaf_par}}) are temperature sensitive. Temperature-sensitive parameters are input at a reference temperature of 25 °C. These parameters are provided as \code{par_name25} and then "baked" using the appropriate temperature response function and parameters in \code{\link{bake_par}}. The "baked" parameter will have the name without "25" appended (\code{par_name}). E.g. \code{V_cmax25} becomes \code{V_cmax}. \cr
\cr
Temperature response functions following Bernacchi et al. 2002. \cr
\cr
Temperature response function 1 (\code{temp_response1}): \cr

\deqn{\mathrm{par}(T_\mathrm{leaf}) = \mathrm{par25}~\mathrm{exp}(E_\mathrm{a} / (R T_\mathrm{ref}) (T_\mathrm{leaf} - 25) / (T_\mathrm{leaf} + 273.15))}{par(T_leaf) = par25 exp(E_a / (R T_ref) (T_leaf - 25) / (T_leaf + 273.15))}

\eqn{T_\mathrm{ref}}{T_ref} is the reference temperature in K \cr
\eqn{T_\mathrm{leaf}}{T_leaf} is the leaf temperature in °C \cr
\cr
Temperature response function 2 (\code{temp_response2}) is the above equation multiplied by: \cr

\deqn{(1 + \mathrm{exp}((D_\mathrm{s} / R - E_\mathrm{d} / (R T_\mathrm{ref})))) / (1 + \mathrm{exp}((D_\mathrm{s} / R) - (E_\mathrm{d} / (R (T_\mathrm{leaf} + 273.15)))))}{(1 + exp((D_s / R - E_d / (R T_ref)))) / (1 + exp((D_s / R) - (E_d / (R (T_leaf + 273.15)))))}

Function 1 increases exponentially with temperature; Function 2 peaks a particular temperature.
}
\examples{
bake_par <- make_bakepar()
constants <- make_constants(use_tealeaves = FALSE)
leaf_par <- make_leafpar(replace = list(T_leaf = set_units(293.15, "K")),
                         use_tealeaves = FALSE)
baked_leafpar <- bake(leaf_par, bake_par, constants)

baked_leafpar$V_cmax25
baked_leafpar$V_cmax

}
\references{
Bernacchi CJ, Portis AR, Nakano H, von Caemmerer S, Long SP. 2002. Temperature response of mesophyll conductance. Implications for the determination of Rubisco enzyme kinetics and for limitations to photosynthesis in vivo. Plant Physiology 130: 1992-8.
}
