% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-fred-csv.r
\name{read_FReD_csv}
\alias{read_FReD_csv}
\title{Read '.CSV' FReD database.}
\usage{
read_FReD_csv(file, date = NA, geocode = NULL, label = NULL, tz = NULL,
  locale = readr::default_locale())
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
A reflectance_spct object.
}
\description{
Reads a CSV data file downloaded from the FReD (Floral Reflectance Database)
and then imports wavelengths and spectral reflectance values and flower ID.
}
\references{
\url{http://www.reflectance.co.uk}
Arnold SEJ, Faruq S, Savolainen V, McOwan PW, Chittka L, 2010 FReD: The 
Floral Reflectance Database — A Web Portal for Analyses of Flower Colour. 
PLoS ONE 5(12): e14287. doi:10.1371/journal.pone.0014287
}
\keyword{misc}
