% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theatrical-gels.r
\docType{data}
\name{theatrical_gels}
\alias{theatrical_gels}
\alias{lee_filters}
\alias{lee_gels}
\alias{rosco_filters}
\alias{rosco_gels}
\title{Filter spectra data for theatrical filter}
\format{
A vector of character strings.

An object of class \code{character} of length 7.

An object of class \code{character} of length 7.

An object of class \code{character} of length 8.

An object of class \code{character} of length 8.
}
\usage{
theatrical_gels

lee_filters

lee_gels

rosco_filters

rosco_gels
}
\description{
Datasets containing the wavelengths at a 1 nm interval and
tabulated values spectral transmittance for different filters used on
light sources as spectral modifiers. Frequently called "theatrical gels".
}
\details{
The variables are as follows:

\itemize{
  \item w.length (nm)
  \item Tfr (fraction)
}
}
\note{
Instruments used: Shimadzu UV-2501 PC (Shimadzu Suzhou Instruments Manufacturing
Co. Ltd, China) equiped with an integrating sphere for Rosco filters except no. 299
which was measured with an Agilent 8453 array spectrophotometer and while
spectra for Lee gels have been digitized from the spectra in the Lee
filters catalogue.
}
\examples{
theatrical_gels

}
\references{
\url{https://www.leefilters.com/lighting/colour-details.html},
\url{https://emea.rosco.com/en/products/family/filters-and-diffusions}
}
\keyword{datasets}
