# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Insert wavelength values into spectral data.
#'
#' Inserting wavelengths values immediately bafore and after a discontinuity in
#' the SWF, gretaly reduces the errors caused by interpolating the weighted
#' irradiance during integration of the effective spectral irradiance. This is
#' specially true when data has a large wavelength step size.
#'
#' @param x numeric array
#' @param y numeric array
#' @param hinges a numeric array giving the wavelengths at which the s.irrad
#'   should be inserted by interpolation, no interpolation is indicated by an
#'   empty array (numeric(0))
#'
#' @return a data.frame with variables \code{w.length} and \code{s.irrad}
#' @name insert_hinges
#' @keywords manip misc
#' @export
#' @examples
#' with(sun.data,
#'     insert_hinges(w.length, s.e.irrad,
#'        c(399.99,400.00,699.99,700.00)))
#' with(sun.data,
#'     insert_hinges(w.length, s.e.irrad,
#'       c(199.99,200.00,399.50,399.99,400.00,699.99,700.00,799.99,1000.00)))
NULL

insert_hinges <- function(x, y, hinges) {
    .Call('photobiology_insert_hinges', PACKAGE = 'photobiology', x, y, hinges)
}

#' Gives irradiance from spectral irradiance.
#'
#' This function gives the result of integrating spectral irradiance over
#' wavelengths. Coded in C++.
#'
#' @param x numeric array
#' @param y numeric array
#'
#' @return a single numeric value with no change in scale factor: e.g. [W m-2
#'   nm-1] -> [W m-2]
#' @keywords manip misc
#' @export
#' @useDynLib photobiology
#' @examples
#' with(sun.data, integrate_xy(w.length, s.e.irrad))
integrate_xy <- function(x, y) {
    .Call('photobiology_integrate_xy', PACKAGE = 'photobiology', x, y)
}

#' Insert interpolated spectral irradiance values.
#'
#' Inserting wavelengths values immediately before and after a discontinuity in
#' the SWF, greatly reduces the errors caused by interpolating the weighted
#' irradiance during integration of the effective spectral irradiance. This is
#' specially true when data has a large wavelength step size.
#'
#' @param x numeric array of wavelength (nm)
#' @param y numeric array of spectral irradiance values
#' @param hinges a numeric array giving the wavelengths at which the s.irrad
#'   should be inserted by interpolation, no interpolation is indicated by an
#'   empty array (numeric(0))
#'
#' @return a numeric vector
#' @name put_hinges
#' @keywords manip misc
#' @export
#'
NULL

put_hinges <- function(x, y, hinges) {
    .Call('photobiology_put_hinges', PACKAGE = 'photobiology', x, y, hinges)
}

