% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photons.energy.ratio.r
\name{photons_energy_ratio}
\alias{photons_energy_ratio}
\title{Photon:energy ratio}
\usage{
photons_energy_ratio(w.length, s.irrad, w.band = NULL,
  unit.in = "energy", check.spectrum = TRUE, use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{w.length}{numeric vector of wavelength (nm).}

\item{s.irrad}{numeric vector of spectral (energy) irradiances (W m-2 nm-1).}

\item{w.band}{waveband object.}

\item{unit.in}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{check.spectrum}{logical Flag telling whether to sanity check input
data, default is TRUE.}

\item{use.cached.mult}{logical Flag telling whether multiplier values should
be cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A single numeric value giving the ratio moles-photons per Joule.
}
\description{
This function gives the photons:energy ratio between for one given waveband
of a radiation spectrum.
}
\note{
The default for the \code{w.band} parameter is a waveband covering
  the whole range of \code{w.length}.
}
\examples{
# photons:energy ratio
with(sun.data, photons_energy_ratio(w.length, s.e.irrad, new_waveband(400,500)))
# photons:energy ratio for whole spectrum
with(sun.data, photons_energy_ratio(w.length, s.e.irrad))

}
\seealso{
Other low-level functions operating on numeric vectors.: \code{\link{as_energy}},
  \code{\link{as_quantum_mol}},
  \code{\link{calc_multipliers}},
  \code{\link{div_spectra}},
  \code{\link{energy_irradiance}},
  \code{\link{energy_ratio}}, \code{\link{insert_hinges}},
  \code{\link{integrate_xy}},
  \code{\link{interpolate_spectrum}},
  \code{\link{irradiance}}, \code{\link{l_insert_hinges}},
  \code{\link{oper_spectra}},
  \code{\link{photon_irradiance}},
  \code{\link{photon_ratio}}, \code{\link{prod_spectra}},
  \code{\link{s_e_irrad2rgb}},
  \code{\link{split_energy_irradiance}},
  \code{\link{split_photon_irradiance}},
  \code{\link{subt_spectra}}, \code{\link{sum_spectra}},
  \code{\link{trim_tails}}, \code{\link{v_insert_hinges}},
  \code{\link{v_replace_hinges}}
}
\concept{low-level functions operating on numeric vectors.}
