% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{convertTimeUnit}
\alias{convertTimeUnit}
\title{Convert the "time.unit" attribute of an existing source_spct object}
\usage{
convertTimeUnit(x, time.unit = NULL, byref = FALSE)
}
\arguments{
\item{x}{a source_spct object}

\item{time.unit}{a character string, either "second", "hour", "day",
"exposure" or "none", or a lubridate::duration}

\item{byref}{logical indicating if new object will be created by reference or
by copy of \code{x} (currently ignored)}
}
\value{
x possibly with the \code{time.unit} attribute modified
}
\description{
Function to set the "time.unit" attribute and simultaneously rescaling the
spectral data to be expressed in the new time unit. The change is done
by reference ('in place')
}
\note{
if x is not a \code{source_spct} or a \code{response_spct} object, or
  time.unit is NULL x is returned unchanged, if the existing or new time.unit
  cannot be converted to a duration, then the returned spectrum will contain
  NAs.
}
\examples{
my.spct <- sun.spct
my.spct
convertTimeUnit(my.spct, "day")

}
\seealso{
Other time attribute functions: \code{\link{checkTimeUnit}},
  \code{\link{getTimeUnit}}, \code{\link{setTimeUnit}}
}
