% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.ratios.R
\name{q_ratio}
\alias{q_ratio}
\alias{q_ratio.default}
\alias{q_ratio.source_mspct}
\alias{q_ratio.source_spct}
\title{Photon:photon ratio}
\usage{
q_ratio(spct, w.band.num, w.band.denom, wb.trim, use.cached.mult, use.hinges,
  ...)

\method{q_ratio}{default}(spct, w.band.num, w.band.denom, wb.trim,
  use.cached.mult, use.hinges, ...)

\method{q_ratio}{source_spct}(spct, w.band.num = NULL, w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ...)

\method{q_ratio}{source_mspct}(spct, w.band.num = NULL, w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ...,
  idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an object of class "source_spct"}

\item{w.band.num}{waveband definition created with new_waveband()}

\item{w.band.denom}{waveband definition created with new_waveband()}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
a single numeric nondimensional value giving a photon ratio between
  pairs of wavebands, with name attribute set to the name of the wavebands
  unless a named list of wavebands is supplied in which case the names of the
  list elements are used, with "(q:q)" appended.
}
\description{
This function returns the photon ratio for a given pair of wavebands of a
light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Method for \code{source_spct} objects

\item \code{source_mspct}: Calculates photon:photon from a \code{source_mspct}
object.
}}
\note{
Recycling for wavebans takes place when the number of denominator and
  denominator wavebands differ. The last two parameters control speed
  optimizations. The defaults should be suitable in mosts cases. If you will
  use repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
q_ratio(sun.spct, new_waveband(400,500), new_waveband(400,700))

}
\seealso{
Other photon and energy ratio functions: \code{\link{e_ratio}},
  \code{\link{energy_ratio}}, \code{\link{eq_ratio}},
  \code{\link{photon_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{qe_ratio}}
}

