% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R
\name{msmsply}
\alias{msmsply}
\alias{msdply}
\alias{mslply}
\alias{msaply}
\title{Multi-spct transform methods}
\usage{
msmsply(mspct, .fun, ..., .parallel = FALSE, .paropts = NULL)

msdply(
  mspct,
  .fun,
  ...,
  idx = NULL,
  col.names = NULL,
  .parallel = FALSE,
  .paropts = NULL
)

mslply(mspct, .fun, ..., .parallel = FALSE, .paropts = NULL)

msaply(mspct, .fun, ..., .drop = TRUE, .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{mspct}{an object of class generic_mspct or a derived class}

\item{.fun}{a function}

\item{...}{other arguments passed to .fun}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{col.names}{character Names to be used for data columns.}

\item{.drop}{should extra dimensions of length 1 in the output be dropped,
simplifying the output. Defaults to TRUE}
}
\value{
a collection of spectra in the case of \code{msmsply}, belonging to a
  different class than \code{mspct} if \code{.fun} modifies the class of the
  member spectra.

a data frame in the case of \code{msdply}

a list in the case of \code{mslply}

an vector in the case of \code{msaply}
}
\description{
Apply a function or operator to a collection of spectra.
}
