% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/led.data.R
\docType{data}
\name{white_led.source_spct}
\alias{white_led.source_spct}
\alias{white_led.cps_spct}
\alias{white_led.raw_spct}
\title{White led bulb spectrum}
\format{
A \code{source_spct} object with 1421 rows and 2 columns,
  a \code{cps_spct} object with 2068 rows and 2 columns, and
  a \code{raw_spct} object with 2068 rows and 4 columns.

An object of class \code{cps_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 2068 rows and 2 columns.

An object of class \code{raw_spct} (inherits from \code{generic_spct}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 2068 rows and 4 columns.
}
\usage{
white_led.source_spct

white_led.cps_spct

white_led.raw_spct
}
\description{
Datasets containing wavelengths and the
  corresponding spectral irradiance data for an Osram warm white led lamp,
  and the corresponding raw instrument counts and counts per second data
  underlying them.
}
\details{
\itemize{ \item w.length (nm), range 250 to 900 nm. \item s.e.irrad
(W m-2 nm-1)}

or

\itemize{ \item w.length (nm), range 188 to 1117 nm. \item cps }

or

\itemize{ \item w.length (nm), range 188 to 1117 nm. \item counts_1 \item counts_2 \item counts_3 }
}
\examples{
white_led.source_spct

}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{phenylalanine.spct}},
\code{\link{photodiode.spct}},
\code{\link{sun.spct}},
\code{\link{sun_daily.spct}},
\code{\link{sun_evening.spct}},
\code{\link{two_filters.spct}},
\code{\link{water.spct}}
}
\concept{Spectral data examples}
\keyword{datasets}
