#' @title White led bulb spectrum
#'
#' @description A dataset containing wavelengths and the
#'   corresponding spectral irradiance data for an Osram warm white led lamp:
#'
#' @details \itemize{ \item w.length (nm), range 250 to 900 nm. \item s.e.irrad
#' (W m-2 nm-1)}
#'
#' @docType data
#' @keywords datasets
#' @format A \code{source_spct} object with 1421 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' white_led.source_spct
#'
"white_led.source_spct"

#' @title White led bulb spectrum
#'
#' @description A dataset containing wavelengths and the
#'   corresponding spectral data as counts per second for an Osram warm white led lamp:
#'
#' @details \itemize{ \item w.length (nm), range 188 to 1117 nm. \item cps }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{data.frame} object with 2068 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' white_led.cps_spct
#'
"white_led.cps_spct"

#' @title White led bulb spectrum
#'
#' @description A dataset containing wavelengths and the
#'   corresponding spectral data as raw instrument counts for an Osram warm white led lamp,
#'   for three different integration times:
#'
#' @details \itemize{ \item w.length (nm), range 188 to 1117 nm. \item counts_1 \item counts_2 \item counts_3 }
#'
#' @docType data
#' @keywords datasets
#' @details \itemize{ \item w.length (nm), range 188 to 1117 nm. \item cps }
#'
#' @family Spectral data examples
#'
#' @examples
#' white_led.raw_spct
#'
"white_led.raw_spct"
