#' @title Transmittance spectrum of clear polyester film
#'
#' @description A dataset containing the wavelengths at a 1 nm interval and
#'   fractional total transmittance for polyester film.
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 611 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' polyester.spct
#'
"polyester.spct"

#' @title Transmittance spectrum of yellow theatrical gel.
#'
#' @description A dataset containing the wavelengths at a 1 nm interval and
#'   fractional total transmittance for polyester film.
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 611 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' yellow_gel.spct
#'
"yellow_gel.spct"

#' @title Theoretical spectrum of a clear material
#'
#' @description A dataset for a hypothetical object with transmittance 1/1
#'   (100\%)
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 4 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' clear.spct
#'
"clear.spct"

#' @title Theoretical spectrum of an opaque material
#'
#' @description A dataset for a hypothetical object with transmittance 0/1
#'   (0\%)
#'
#' @details \itemize{ \item w.length (nm). \item Tfr
#' (0..1)  }
#'
#' @docType data
#' @keywords datasets
#' @format A \code{filter_spct} object with 4 rows and 2 variables
#' @family Spectral data examples
#'
#' @examples
#' opaque.spct
#'
"opaque.spct"
