% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.r
\name{q2e}
\alias{q2e}
\alias{q2e.default}
\alias{q2e.source_spct}
\alias{q2e.response_spct}
\alias{q2e.source_mspct}
\alias{q2e.response_mspct}
\title{Convert photon-based quantities into energy-based quantities}
\usage{
q2e(x, action, byref, ...)

\method{q2e}{default}(x, action = "add", byref = FALSE, ...)

\method{q2e}{source_spct}(x, action = "add", byref = FALSE, ...)

\method{q2e}{response_spct}(x, action = "add", byref = FALSE, ...)

\method{q2e}{source_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)

\method{q2e}{response_mspct}(x, action = "add", byref = FALSE, ..., .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{x}{an R object}

\item{action}{a character string}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{...}{not used in current version}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\description{
Function that converts spectral photon irradiance (molar) into spectral energy irradiance.
}
\section{Methods (by class)}{
\itemize{
\item \code{q2e(default)}: Default method

\item \code{q2e(source_spct)}: Method for spectral irradiance

\item \code{q2e(response_spct)}: Method for spectral responsiveness

\item \code{q2e(source_mspct)}: Method for collections of (light) source spectra

\item \code{q2e(response_mspct)}: Method for collections of response spectra

}}
\seealso{
Other quantity conversion functions: 
\code{\link{A2T}()},
\code{\link{Afr2T}()},
\code{\link{T2Afr}()},
\code{\link{T2A}()},
\code{\link{any2T}()},
\code{\link{as_quantum}()},
\code{\link{e2qmol_multipliers}()},
\code{\link{e2quantum_multipliers}()},
\code{\link{e2q}()}
}
\concept{quantity conversion functions}
