#' print.phenologyout prints the information from a result x.
#' @title Print the information from a ouput x.
#' @author Marc Girondot
#' @return None
#' @param x An output generated by plot_phenology
#' @param ... Not used
#' @description The function print.phenologyout displays the output of a summary(phenology).
#' @family Phenology model
#' @examples
#' \dontrun{
#' library(phenology)
#' # Read a file with data
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot<-add_phenology(Gratiot, name="Complete", 
#' 		reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, fixed.parameters=NULL)
#' # Run the optimisation
#' result_Gratiot <- fit_phenology(data=data_Gratiot, 
#' 		fitted.parameters=parg, fixed.parameters=NULL)
#' data(result_Gratiot)
#' # Plot the phenology and get some stats
#' output <- plot(result_Gratiot)
#' # Show the output
#' output
#' }
#' @method print phenologyout
#' @export


print.phenologyout <- function(x, ...) {

  object <- x
  
  cat(paste("Number of timeseries: ", nrow(object$synthesis), "\n", sep=""))
  
  for (i in 1:nrow(object$synthesis)) {
    nmser <- object$synthesis[i, "series"]
    tx <- paste0("Timeseries: ", nmser)
    cat(paste0(rep("-", nchar(tx)), collapse=""), "\n")
    cat(tx, "\n")
    cat(paste0(rep("-", nchar(tx)), collapse=""), "\n")
    
    cat("Total estimate not taking into account the observations: ")
    cat(paste0("Mean=", object$synthesis[nmser, "without_obs_Mean"], "\n"))
    
    cat("Total estimate taking into account the observations: ")
    cat(paste0("Mean=", object$synthesis[nmser, "with_obs_Mean"], "\n"))
    
    if (!is.na(object$synthesis[nmser, "without_obs_Median_ML"])) {
      cat("Total estimate not taking into account the observations ML-based:\n")
      cat(paste0("Low=", object$synthesis[nmser, "without_obs_Low_ML"], 
                 "   Median=", object$synthesis[nmser, "without_obs_Median_ML"], 
                 "   High=", object$synthesis[nmser, "without_obs_High_ML"], "\n"))
      
      cat("Total estimate taking into account the observations ML-based:\n")
      cat(paste0("Low=", object$synthesis[nmser, "with_obs_Low_ML"], 
                 "   Median=", object$synthesis[nmser, "with_obs_Median_ML"], 
                 "   High=", object$synthesis[nmser, "with_obs_High_ML"], "\n"))
    }
    
    if (!is.na(object$synthesis[nmser, "without_obs_Median_MCMC"])) {
      cat("Total estimate not taking into account the observations MCMC-based:\n")
      cat(paste0("Low=", object$synthesis[nmser, "without_obs_Low_MCMC"], 
                 "   Median=", object$synthesis[nmser, "without_obs_Median_MCMC"], 
                 "   High=", object$synthesis[nmser, "without_obs_High_MCMC"], "\n"))
      
      cat("Total estimate taking into account the observations MCMC-based:\n")
      cat(paste0("Low=", object$synthesis[nmser, "with_obs_Low_MCMC"], 
                 "   Median=", object$synthesis[nmser, "with_obs_Median_MCMC"], 
                 "   High=", object$synthesis[nmser, "with_obs_High_MCMC"], "\n"))
    }
    
    
  }
  
  
  
  
}
