% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ECFOCF.R
\name{plot.ECFOCF}
\alias{plot.ECFOCF}
\title{Plot a result of clutch frequency fit.}
\usage{
\method{plot}{ECFOCF}(
  x,
  ...,
  result = "CF",
  category = NA,
  period = 1,
  resultMCMC = NULL,
  chain = 1,
  replicates = "all"
)
}
\arguments{
\item{x}{A result for fitCF().}

\item{...}{Graphic parameters, see plot.TableECFOCF() or par.}

\item{result}{What result will be plotted: data, dataOCF, dataECF, ECF, OCF, ECFOCF, ECFOCF0, CF, Prob, period}

\item{category}{What category will be plotted, numeric or NA for all.}

\item{period}{The period that will be plotted.}

\item{resultMCMC}{A result from fitRMU_MHmcmc.}

\item{chain}{Which chain to be used in resultMCMC.}

\item{replicates}{How many replicates fron resultMCMC.}
}
\value{
Nothing
}
\description{
This function plots the result of fitCF().\cr
The result \code{data} plots the observed ECF-OCF table.\cr
The result \code{dataOCF} plots the observed OCF table.\cr
The result \code{dataECF} plots the observed ECF table.\cr
The result \code{CF} plots the true clutch frequency.\cr
The result \code{OCF} plots the observed clutch frequency.\cr
The result \code{ECF} plots the estimated clutch frequency.\cr
The result \code{ECFOCF} plots the bivariate observed vs. estimated clutch frequency.\cr
The result \code{ECFOCF0} plots the bivariate observed vs. estimated clutch frequency without the 0 OCF.\cr
The result \code{prob} plots the probabilities of capture.\cr
The result \code{period} plots the probabilities of nesting according to period.\cr
If category is left to NA, the compound value for all the population is plotted.\cr
When result="data" is used, this is a parser for plot.TableECFOCF().\cr
See this function for the parameters.\cr
The parameter y.axis is the shift of the x legends for result="prob".\cr
When a \code{resultMCMC} is indicated, if replicates is "all", all values are used; 
if a value lower than number of iterations is indicated, a regular thinning is used and 
if a value larger then number if iteration is indicated, a sampling with replacement is used.\cr
}
\details{
plot.ECFOCF plots a result of clutch frequency fit.
}
\examples{
\dontrun{
library(phenology)
# Example
data(MarineTurtles_2002)
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002)
o_mu1p2_NB <- fitCF(x = c(mu = 4.6426989650675701, 
                         sd = 75.828239144717074, 
                         p1 = 0.62036295627161053,
                         p2 = -2.3923021862881511, 
                         OTN = 0.33107456308054345),
                 data=ECFOCF_2002)
                 
par(mar=c(4, 4, 1, 1)+0.4)
plot(o_mu1p2_NB, result="data", category=NA, 
     bty="n", las=1, cex.points=3, cex.axis = 0.8)
plot(o_mu1p2_NB,result="data", category=NA, 
     bty="n", las=1, cex.points=3, pch=NA, 
     col.labels = "red", show.labels=TRUE, cex.0=0.2, 
     show.0 = TRUE, col.0="blue", pch.0=4)
plot(o_mu1p2_NB, result="dataOCF", category=NA, 
     bty="n", las=1)
plot(o_mu1p2_NB, result="dataECF", category=NA, 
     bty="n", las=1)
     
plot(o_mu1p2_NB, result="CF", bty="n", las=1)

plot(o_mu1p2_NB, result="OCF", category=1, bty="n", las=1)
plot(o_mu1p2_NB, result="OCF", category=2, bty="n", las=1)

plot(o_mu1p2_NB, result="ECFOCF", bty="n", las=1)

plot(o_mu1p2_NB, result="ECFOCF0", bty="n", las=1)
plot(o_mu1p2_NB, result="ECFOCF0", category=1, bty="n", las=1)
plot(o_mu1p2_NB, result="ECFOCF0", category=2, bty="n", las=1)

plot(o_mu1p2_NB, result="Prob", category=c(1, 2), bty="n", las=1)
plot(o_mu1p2_NB, result="Prob", category=c(2, 1), bty="n", las=1)

}
}
\seealso{
Other Model of Clutch Frequency: 
\code{\link{ECFOCF_full}()},
\code{\link{ECFOCF_f}()},
\code{\link{TableECFOCF}()},
\code{\link{fitCF_MHmcmc_p}()},
\code{\link{fitCF_MHmcmc}()},
\code{\link{fitCF}()},
\code{\link{generateCF}()},
\code{\link{lnLCF}()},
\code{\link{logLik.ECFOCF}()},
\code{\link{plot.TableECFOCF}()}
}
\author{
Marc Girondot
}
\concept{Model of Clutch Frequency}
