% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_SE.R
\name{add_SE}
\alias{add_SE}
\title{Add standard error for a fixed parameter.}
\usage{
add_SE(fixed.parameters = NULL, parameters = NULL, SE = NULL)
}
\arguments{
\item{fixed.parameters}{Set of fixed parameters}

\item{parameters}{Set of current parameters}

\item{SE}{Standard error value to be added}
}
\value{
The parameters set with the new SE value
}
\description{
This function is used to add standard error for a fixed parameter.
}
\details{
add_SE adds standard error for a fixed parameter.
}
\examples{
library(phenology)
# Generate a set of fixed parameter: Flat and Min
pfixed<-c(Flat=0, Min=0)
# Add SE for the Flat parameter
pfixed<-add_SE(fixed.parameters=pfixed, parameters="Flat", SE=5)
}
\author{
Marc Girondot
}
