% Generated by roxygen2 (4.0.1): do not edit by hand
\name{print.phenologyout}
\alias{print.phenologyout}
\title{Print the information from a ouput object.}
\usage{
\method{print}{phenologyout}(x, ...)
}
\arguments{
\item{x}{An output generated by plot_phenology}

\item{...}{Not used}
}
\value{
None\cr
}
\description{
The function print.phenologyout displays the output from a plot.
}
\details{
print.phenologyout prints the information from a result object.
}
\examples{
library(phenology)
# Read a file with data
\dontrun{
Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
}
data(Gratiot)
# Generate a formatted list nammed data_Gratiot
data_Gratiot<-add_phenology(Gratiot, name="Complete",
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg<-par_init(data_Gratiot, parametersfixed=NULL)
# Run the optimisation
\dontrun{
result_Gratiot<-fit_phenology(data=data_Gratiot,
		parametersfit=parg, parametersfixed=NULL, trace=1)
}
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot)
# Show the output
output
}
\author{
Marc Girondot
}

