% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{callPROCEDURE}
\alias{callPROCEDURE}
\title{Generate a postgreSQL statement to execute a procedure, optionally execute the statement if con is not NULL.}
\usage{
callPROCEDURE(
  x = list(),
  schema = NULL,
  proc,
  quote_text = TRUE,
  cast = TRUE,
  types,
  con = NULL
)
}
\arguments{
\item{x}{A named list, names must match the parameter names of the SQL procedure, values are the values to set the parameters to when executing the SQL procedure.}

\item{schema}{A string, the schema name of the SQL procedure.}

\item{proc}{A string, the name of the SQL procedure.}

\item{quote_text}{TRUE/FALSE, if TRUE, calls quoteText() to add single quotes around character strings.}

\item{cast}{TRUE/FALSE, if TRUE, will add SQL to cast the parameters to the specified type.}

\item{types}{A vector of character strings specifying the SQL data types of the procedure parameters, the position of the type should match the position of the parameter for that type in x.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL statement to execute a procedure; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL statement to execute a procedure, optionally execute the statement if con is not NULL.
}
\examples{
callPROCEDURE(
x = list(a = 1, b = 2),
schema = NULL,
proc = "sample_add",
quote_text = TRUE,
cast = FALSE,
types = c("INT", "INT")
)
}
