% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_match.R
\name{is_ds043_2006_ag}
\alias{is_ds043_2006_ag}
\title{Matching for DS 043-2006-AG Species}
\usage{
is_ds043_2006_ag(splist, prioritize = "original", return_details = FALSE)
}
\arguments{
\item{splist}{Character vector of species names to check}

\item{prioritize}{Character. Which result to prioritize when both databases
match: "original" (default) or "updated"}

\item{return_details}{Logical. Return detailed matching information}
}
\value{
If return_details = FALSE: Character vector with consolidated threat status.
If return_details = TRUE: Tibble with detailed reconciliation information.
}
\description{
Performs consolidated matching that searches species names in both the original
DS 043-2006-AG list (2006 names) and the updated nomenclature database. This
ensures that users with updated names can still identify if their species are
protected under the DS 043-2006-AG, even if the nomenclature has updated.
}
\details{
The function performs a two-stage search:

1. Searches in original DS 043-2006-AG (names as listed in 2006)
2. Searches in updated nomenclature database (current accepted names)
3. Consolidates results with clear indication of which database provided the match
4. Identifies if original names are now synonyms

This approach handles cases where:
- User provides original name from 2006: Found in original database
- User provides updated name: Found in updated database and linked to DS 043-2006-AG list
- Name matches in both: Returns most relevant result based on priority
- Original name is now a synonym: Indicated with "(synonym)" marker
}
\examples{
\dontrun{
# Species with nomenclatural changes
species <- c(
  "Haageocereus acranthus subsp. olowinskianus",  # Original name
  "Brassia ocanensis",                            # Updated name (was Ada)
  "Ida locusta",                                  # Updated name
  "Lycaste locusta",                              # Now a synonym
  "Persea americana"                              # Not threatened
)

# Get consolidated status
status <- is_ds043_2006_ag(species)

# Get detailed information
details <- is_ds043_2006_ag(species, return_details = TRUE)
View(details)
}

}
