% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_helpers_external.R
\name{load_announcements}
\alias{load_announcements}
\title{load_announcements}
\usage{
load_announcements(
  announcements_file_path = NULL,
  announcement_location_id = "announceAlert"
)
}
\arguments{
\item{announcements_file_path}{The path to announcements configuration file.\cr
Use \link[periscope2]{announcementConfigurationsAddin} to generate that file.}

\item{announcement_location_id}{Announcement target location div id (default = "announceAlert")}
}
\value{
number of seconds an announcement should be staying in caller application
}
\description{
Reads and parses application announcements configurations in \code{config/announce.yaml}, then display announcements in
application header.
}
\details{
If announce.yaml does not exist or contains invalid configurations. Nothing will be displayed.
Closing announcements is caller application responsibility
}
\examples{
    load_announcements(system.file("fw_templ/announce.yaml", package = "periscope2"))

}
\seealso{
\link[periscope2:announcementConfigurationsAddin]{periscope2:announcementConfigurationsAddin()}
}
