% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_left_sidebar}
\alias{add_ui_left_sidebar}
\title{Add UI elements to dashboard left sidebar section}
\usage{
add_ui_left_sidebar(
  sidebar_elements = NULL,
  sidebar_menu = NULL,
  collapsed = FALSE,
  custom_area = NULL,
  elevation = 4,
  expand_on_hover = TRUE,
  fixed = TRUE,
  minified = FALSE,
  status = "primary",
  skin = "light"
)
}
\arguments{
\item{sidebar_elements}{- List of regular shiny UI elements (inputText, textArea, etc..)}

\item{sidebar_menu}{- \code{?bs4Dash::bs4SidebarMenu()} object to created a menu inside left sidebar}

\item{collapsed}{- If TRUE, the sidebar will be collapsed on app start up}

\item{custom_area}{- List of regular shiny UI elements but for sidebar bottom space area only.
Only works if sidebar is fixed}

\item{elevation}{- A number between 0 and 5, which applies a shadow to the sidebar to add a shadow effect.}

\item{expand_on_hover}{- When \code{minified} is TRUE, if this property is TRUE, the sidebar opens when hovering but re-collapses as soon as the focus is lost (default = TRUE)}

\item{fixed}{- Whether to see all menus at once without scrolling up and down.(default = TRUE)}

\item{minified}{- Whether to slightly close the sidebar but still show item icons (default = FALSE)}

\item{status}{- Determines which color menu items (if exist) will have Check \code{?bs4Dash::dashboardSidebar()} for list of valid values}

\item{skin}{- Sidebar skin. "dark" or "light" (default = "light")}
}
\value{
list of both shiny UI elements and named left sidebar properties
}
\description{
This function adds left sidebar configurations and UI elements. It is called within "ui_left_sidebar.R".
Check example application for detailed example
}
\section{Shiny Usage}{

Call this function from \code{program/ui_left_sidebar.R} to set left sidebar parameters
}

\examples{
  library(shiny)
  library(bs4Dash)
  # Inside ui_left_sidebar.R
  # sidebar menu items
  sidebar_elements <- textInput("text_id", "Test", "Test Data")
  sidebar_menu     <- sidebarMenu(sidebarHeader("Main Menu"),
                                  menuItem("menu item 1",
                                           tabName = "item_1 page"),
                                  menuItem("menu item 2",
                                           tabName = "item_2 page"))
  add_ui_left_sidebar(sidebar_elements = sidebar_elements,
                      sidebar_menu     = sidebar_menu)
}
\seealso{
\link[bs4Dash:bs4DashSidebar]{bs4Dash:bs4DashSidebar()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
