% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_rse.R
\name{performance_rse}
\alias{performance_rse}
\title{Residual Standard Error for Linear Models}
\usage{
performance_rse(model)
}
\arguments{
\item{model}{A model.}
}
\value{
Numeric, the residual standard error of \code{model}.
}
\description{
Compute residual standard error of linear models.
}
\details{
The residual standard error is the square root of the residual
  sum of squares divided by the residual degrees of freedom.
}
\examples{
data(mtcars)
m <- lm(mpg ~ hp + gear, data = mtcars)
performance_rse(m)
}
