% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2.R
\name{r2}
\alias{r2}
\title{Compute the model's R2}
\usage{
r2(model, ...)
}
\arguments{
\item{model}{A statistical model.}

\item{...}{Currently not used.}
}
\value{
Returns a list containing values related to the most appropriate R2
  for the given model. See the list below:
\itemize{
  \item Logistic models: \link[=r2_tjur]{Tjur's R2}
  \item General linear models: \link[=r2_nagelkerke]{Nagelkerke's R2}
  \item Multinomial Logit: \link[=r2_mcfadden]{McFadden's R2}
  \item Models with zero-inflation: \link[=r2_zeroinflated]{R2 for zero-inflated models}
  \item Mixed models: \link[=r2_nakagawa]{Nakagawa's R2}
  \item Bayesian models: \link[=r2_bayes]{R2 bayes}
}
}
\description{
Calculate the R2 value for different model objects. Depending
  on the model, R2, pseudo-R2 or marginal / adjusted R2 values are returned.
}
\examples{
model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
r2(model)

library(lme4)
model <- lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
r2(model)
}
\seealso{
\code{\link{r2_bayes}}, \code{\link{r2_coxsnell}}, \code{\link{r2_kullback}},
  \code{\link{r2_loo}}, \code{\link{r2_mcfadden}}, \code{\link{r2_nagelkerke}},
  \code{\link{r2_nakagawa}}, \code{\link{r2_tjur}}, \code{\link{r2_xu}} and
  \code{\link{r2_zeroinflated}}.
}
