% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_overdispersion.R
\name{check_overdispersion}
\alias{check_overdispersion}
\title{Check overdispersion of GL(M)M's}
\usage{
check_overdispersion(x, ...)
}
\arguments{
\item{x}{Fitted model of class \code{merMod}, \code{glmmTMB}, \code{glm},
or \code{glm.nb} (package \pkg{MASS}).}

\item{...}{Currently not used.}
}
\value{
A list with results from the overdispersion test, like chi-squared
 statistics, p-value or dispersion ratio.
}
\description{
\code{check_overdispersion()} checks generalized linear (mixed) models
   for overdispersion.
}
\details{
A p-value < .05 indicates overdispersion. For \code{merMod}- and
   \code{glmmTMB}-objects, \code{check_overdispersion()} is based on the code in
   the \href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ},
   section \emph{How can I deal with overdispersion in GLMMs?}. Note that
   this function only returns an \emph{approximate} estimate of an
   overdispersion parameter, and is probably inaccurate for zero-inflated
   mixed models (fitted with \code{glmmTMB}). The same code is also used to
   check overdispersion for negative binomial models.
   \cr \cr
   For Poisson-models, the overdispersion test is based on the code
   from \cite{Gelman and Hill (2007), page 115}.
   \cr \cr
   Overdispersion can be fixed by either modelling the dispersion parameter,
   or by choosing a different distributional family (like Quasi-Poisson,
   or negative binomial, see \cite{Gelman and Hill (2007), pages 115-116}).
}
\examples{
library(glmmTMB)
data(Salamanders)

m <- glm(count ~ spp + mined, family = poisson, data = Salamanders)
check_overdispersion(m)

m <- glmmTMB(
  count ~ mined + spp + (1 | site),
  family = poisson,
  data = Salamanders
)
check_overdispersion(m)

}
\references{
\itemize{
 \item Bolker B et al. (2017): \href{http://bbolker.github.io/mixedmodels-misc/glmmFAQ.html}{GLMM FAQ.}
 \item Gelman, A., & Hill, J. (2007). Data analysis using regression and multilevel/hierarchical models. Cambridge; New York: Cambridge University Press.
 }
}
