% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_mlm.R
\name{r2_mlm}
\alias{r2_mlm}
\title{Multivariate R2}
\usage{
r2_mlm(model, ...)
}
\arguments{
\item{model}{Multivariate linear regression model.}

\item{...}{Currently not used.}
}
\value{
A named vector with the R2 values.
}
\description{
Calculates two multivariate R2 values for multivariate linear regression.
}
\details{
The two indexes returned summarize model fit for the set of predictors
given the system of responses. As compared to the default
\link[=r2]{r2} index for multivariate linear models, the indexes
returned by this function provide a single fit value collapsed across
all responses.

The two returned indexes were proposed by \emph{Van den Burg and Lewis (1988)}
as an extension of the metrics proposed by \emph{Cramer and Nicewander (1979)}.
Of the numerous indexes proposed across these two papers, only two metrics,
the \eqn{R_{xy}} and \eqn{P_{xy}}, are recommended for use
by \emph{Azen and Budescu (2006)}.

For a multivariate linear regression with \eqn{p} predictors and
\eqn{q} responses where \eqn{p > q}, the \eqn{R_{xy}} index is
computed as:

\deqn{R_{xy} = 1 - \prod_{i=1}^p (1 - \rho_i^2)}

Where \eqn{\rho} is a canonical variate from a
\link[=cancor]{canonical correlation} between the predictors and responses.
This metric is symmetric and its value does not change when the roles of
the variables as predictors or responses are swapped.

The \eqn{P_{xy}} is computed as:

\deqn{P_{xy} = \frac{q - trace(\bf{S}_{\bf{YY}}^{-1}\bf{S}_{\bf{YY|X}})}{q}}

Where \eqn{\bf{S}_{\bf{YY}}} is the matrix of response covariances and
\eqn{\bf{S}_{\bf{YY|X}}} is the matrix of residual covariances given
the predictors. This metric is asymmetric and can change
depending on which variables are considered predictors versus responses.
}
\examples{
model <- lm(cbind(qsec, drat) ~ wt + mpg + cyl, data = mtcars)
r2_mlm(model)

model_swap <- lm(cbind(wt, mpg, cyl) ~ qsec + drat, data = mtcars)
r2_mlm(model_swap)

}
\references{
\itemize{
\item Azen, R., & Budescu, D. V. (2006). Comparing predictors in
multivariate regression models: An extension of dominance analysis.
Journal of Educational and Behavioral Statistics, 31(2), 157-180.
\item Cramer, E. M., & Nicewander, W. A. (1979). Some symmetric,
invariant measures of multivariate association. Psychometrika, 44, 43-54.
\item Van den Burg, W., & Lewis, C. (1988). Some properties of two
measures of multivariate association. Psychometrika, 53, 109-122.
}
}
\author{
Joseph Luchman
}
