% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramer.R
\name{cramer}
\alias{cramer}
\title{Association between categorical variables}
\usage{
cramer(x)
}
\arguments{
\item{x}{Data frame or matrix with a set of categorical variables.}
}
\value{
A matrix with the Cramer's V between the categorical variables.
}
\description{
Compute the Cramer's V, a descriptive statistic that measures the association between categorical
variables.
}
\details{
Any integer variable is internally converted to a factor.
}
\note{
The original code is available at \url{https://sas-and-r.blogspot.com/}, Example 8.39:
calculating Cramer's V, posted by Ken Kleinman on Friday, June 3, 2011. As such, Ken Kleinman
\email{Ken_Kleinman@hms.harvard.edu} is entitled a \sQuote{contributor} to the R-package
\strong{pedometrics}.
}
\section{Reverse dependencies}{

The \strong{spsann} package, provider of methods for the optimization of sample configurations using
spatial simulated annealing in R, requires \code{\link[=cramer]{cramer()}} for some of its functions to
work. The development version of the \strong{spsann} package is available on
\url{https://github.com/Laboratorio-de-Pedometria/spsann-package}.
}

\examples{
if (interactive()) {
  data(meuse, package = "sp")
  str(meuse)
  test <- cramer(meuse[, c("ffreq", "soil", "lime", "landuse")])
}
}
\references{
Cramér, H. \emph{Mathematical methods of statistics}. Princeton: Princeton University Press, p. 575,
1946.

Everitt, B. S. \emph{The Cambridge dictionary of statistics}. Cambridge: Cambridge University Press,
p. 432, 2006.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
