% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ps_bib}
\alias{ps_bib}
\title{A \code{BibTeX} Data Frame of Citations}
\format{
A data frame with 37 observations on the following 40 variables.
\describe{
\item{\code{CATEGORY}}{the \code{BibTeX} entry type}
\item{\code{BIBTEXKEY}}{the \code{BibTeX} unique entry key}
 \item{\code{ADDRESS}}{another \code{BibTeX} field}
\item{\code{ANNOTE}}{another \code{BibTeX} field}
\item{\code{AUTHOR}}{a list of authors for this entry}
\item{\code{BOOKTITLE}}{another \code{BibTeX} field, for book title (if appropriate)}
\item{\code{CHAPTER}}{another \code{BibTeX} field, for chapter (if appropriate)}
\item{\code{CROSSREF}}{another \code{BibTeX} field}
\item{\code{EDITION}}{another \code{BibTeX} field, for edition of book (if appropriate)}
\item{\code{EDITOR}}{another \code{BibTeX} field, for book editor (if appropriate)}
\item{\code{HOWPUBLISHED}}{another \code{BibTeX} field}
\item{\code{INSTITUTION}}{another \code{BibTeX} field}
\item{\code{JOURNAL}}{another \code{BibTeX} field, for the journal name (if appropriate)}
\item{\code{KEY}}{another \code{BibTeX} field}
\item{\code{MONTH}}{another \code{BibTeX} field}
\item{\code{NOTE}}{another \code{BibTeX} field}
\item{\code{NUMBER}}{another \code{BibTeX} field, for journal volume number (if appropriate)}
\item{\code{ORGANIZATION}}{another \code{BibTeX} field}
\item{\code{PAGES}}{another \code{BibTeX} field, for pages of the entry}
\item{\code{PUBLISHER}}{another \code{BibTeX} field, for book publisher (if appropriate)}
\item{\code{SCHOOL}}{another \code{BibTeX} field}
\item{\code{SERIES}}{another \code{BibTeX} field}
\item{\code{TITLE}}{another \code{BibTeX} field, for title of the entry}
\item{\code{TYPE}}{another \code{BibTeX} field}
\item{\code{VOLUME}}{another \code{BibTeX} field, for journal volume (if appropriate)}
\item{\code{YEAR}}{another \code{BibTeX} field, for year of publication}
\item{\code{KEYWORDS}}{another \code{BibTeX} field, used primarily for selective filtering in this package}
\item{\code{URL}}{another \code{BibTeX} field, for website (if appropriate)}
\item{\code{OWNER}}{another \code{BibTeX} field}
\item{\code{TIMESTAMP}}{another \code{BibTeX} field, used occasionally when I started populating my master file (you will see some old entries here)}
\item{\code{DOI}}{another \code{BibTeX} field, for a digital object identifier (used rarely)}
\item{\code{EPRINT}}{another \code{BibTeX} field}
\item{\code{JOURNALTITLE}}{another \code{BibTeX} field, which I think is actually a \code{BibLaTeX} field}
\item{\code{ISSN}}{another \code{BibTeX} field}
\item{\code{ABSTRACT}}{another \code{BibTeX} field, for entry abstract (if appropriate)}
\item{\code{DATE.ADDED}}{another \code{BibTeX} field}
\item{\code{DATE.MODIFIED}}{another \code{BibTeX} field}
}
}
\usage{
ps_bib
}
\description{
This is a \code{BibTeX} file, loaded as a data frame, to assist the user in properly citing the source material that is used in this package.
}
\details{
See \code{data-raw} directory for how these data were generated. The data were created by \pkg{bib2df}, which is now a package dependency.
I assume the user has some familiarity with \code{BibTeX}. Some entries were copy-pasted from my master bibliography file that I started in 2008 or so.
}
\keyword{datasets}
