% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_archigos.R
\name{add_archigos}
\alias{add_archigos}
\title{Add Archigos political leader information to dyad-year and state-year data}
\usage{
add_archigos(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed") or state-year data frame}
}
\value{
\code{add_archigos()} takes a dyad-year or state-year data frame and adds a few summary
variables based off the leader-level data. These include whether there was a leader transition in the
state-year (or first/second state in the dyad-year), whether there was an "irregular" leader transition,
the number of leaders in the state-year, the unique leader ID for Jan. 1 of the year, and the unique leader
ID for Dec. 31 of the year.
}
\description{
\code{add_archigos()} allows you to add some information about leaders to dyad-year
or state-year data. The function leans on an abbreviated version of the data, which also comes in this package.
}
\details{
The function leans on attributes of the data that are provided by the \code{create_dyadyear()} or
\code{create_stateyear()} function. Make sure that function (or data created by that function) appear at the top
of the proverbial pipe.
}
\examples{
\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)

cow_ddy \%>\% add_archigos()

create_stateyears() \%>\% add_archigos()
}


}
\references{
Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing Archigos: A Dataset of Political Leaders"
\emph{Journal of Peace Research} 46(2): 269--83.
}
\author{
Steven V. Miller
}
