% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_mids.R
\name{add_mids}
\alias{add_mids}
\title{Add Gibler-Miller-Little (GML) Militarized Interstate Dispute (MID) data to dyad-year data frame}
\usage{
add_mids(data, keep)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed")}

\item{keep}{an optional parameter, specified as a character vector, passed to the function in a \code{select(one_of(.))} wrapper. This
allows the user to discard unwanted columns from the directed dispute data so that the output does not consume
too much space in memory. Note: the Correlates of War system codes (\code{ccode1}, \code{ccode2}), the observation year
(\code{year}), the presence or absence of an ongoing MID (\code{midongoing}), and the presence or absence of a unique
MID onset (\code{midonset}) are *always* returned. It would be foolish and self-defeating to eliminate those observations.
The user is free to keep or discard anything else they see fit.

If \code{keep} is not specified in the function, the ensuing output returns everything.}
}
\value{
\code{add_mids()} takes a dyad-year data frame and adds dyad-year dispute information
from the GML MID data.
}
\description{
\code{add_mids()} merges in GML's MID data to a dyad-year data frame. The current version
of the GML MID data is 2.1.1.
}
\details{
Dyads are capable of having multiple disputes in a given year, which can create a problem
for merging into a complete dyad-year data frame. Consider the case of France and Italy in 1860, which
had three separate dispute onsets that year (MID#0112, MID#0113, MID#0306), as illustrative of the problem.
This merging process employs the following rules to whittle down these duplicate dispute-year observations. It
first selects on MID onsets, then selecting highest fatality level, then highest hostility level, then
the longest estimating minimum dispute duration, and finally, in the event of duplicates still outstanding,
selecting the MID that came first. This is how GML present their full directed and non-directed dyad-year data.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
cow_ddy \%>\% add_mids()

# keep just the dispute number and Side A/B identifiers
cow_ddy \%>\% add_mids(keep=c("dispnum","sidea1", "sidea2"))
}

}
\references{
Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis of the Militarized
Interstate Dispute (MID) Dataset, 1816-2001.” International Studies Quarterly 60(4): 719-730.
}
\author{
Steven V. Miller
}
