% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{Xin.convex.hullY}
\alias{Xin.convex.hullY}
\title{Points from one class inside the convex hull of the points
from the other class}
\usage{
Xin.convex.hullY(Xp, Yp)
}
\arguments{
\item{Xp}{A set of 2D points
which constitute the data set.}

\item{Yp}{A set of 2D points
which constitute the vertices of the Delaunay triangles.}
}
\value{
\code{Xp} points inside the convex hull of \code{Yp} points
}
\description{
Given two 2D data sets, \code{Xp} and \code{Yp},
it returns the \code{Xp} points
inside the convex hull of \code{Yp} points.

See (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-5;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

DT<-interp::tri.mesh(Yp[,1],Yp[,2],duplicate="remove")

Xlim<-range(Xp[,1],Yp[,1])
Ylim<-range(Xp[,2],Yp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

Xch<-Xin.convex.hullY(Xp,Yp)

plot(Xp,main=" ", xlab=" ", ylab=" ",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05),pch=".",cex=3)
interp::convex.hull(DT,plot.it = TRUE, add = TRUE)  # or try polygon(Yp[ch$i,])
points(Xch,pch=4,col="red")
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotDelaunay.tri}}
}
\author{
Elvan Ceyhan
}
