% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IndNPETe}
\alias{IndNPETe}
\title{The indicator for the presence of an arc from a point to another for Proportional Edge Proximity Catch
Digraphs (PE-PCDs) - standard equilateral triangle case}
\usage{
IndNPETe(p1, p2, r, M = c(1, 1, 1), rv = NULL)
}
\arguments{
\item{p1}{A 2D point whose PE proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the PE proximity region of
\code{p1} or not.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}

\item{rv}{The index of the vertex region in \eqn{T_e} containing the point, either \code{1,2,3} or \code{NULL}
(default is \code{NULL}).}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise, where \eqn{N_{PE}(x,r)} is the PE proximity region for point \eqn{x} with expansion parameter \eqn{r \ge 1}.

PE proximity region is defined with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and vertex regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
\code{rv} is the index of the vertex region \code{p1} resides, with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct and either of them are outside \eqn{T_e}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-3

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

IndNPETe(Xp[1,],Xp[3,],r=1.5,M)
IndNPETe(Xp[1,],Xp[3,],r=2,M)

#or try
Rv<-rvTeCM(Xp[1,])$rv
IndNPETe(Xp[1,],Xp[3,],r=2,rv=Rv)

P1<-c(.4,.2)
P2<-c(.5,.26)
r<-2
IndNPETe(P1,P2,r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNPEtri}}, \code{\link{IndNPEbas.tri}}, and \code{\link{IndNCSTe}}
}
\author{
Elvan Ceyhan
}
