% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{IncMatPETe}
\alias{IncMatPETe}
\title{Incidence matrix for Proportional Edge Proximity Catch Digraphs (PE-PCDs) - standard
equilateral triangle case}
\usage{
IncMatPETe(Xp, r, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the PE-PCD.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 2D data set, \code{Xp} and PE proximity
regions are defined in the standard equilateral triangle \eqn{T_e} with \code{M}-vertex regions.
}
\description{
Returns the incidence matrix for the PE-PCD whose vertices are the given 2D numerical data set, \code{Xp},
in the standard equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}.

PE proximity region is constructed with respect to the standard equilateral triangle \eqn{T_e} with
expansion parameter \eqn{r \ge 1} and vertex regions are based on
the center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

inc.mat<-IncMatPETe(Xp,r=1.25,M)
inc.mat
sum(inc.mat)-n
NumArcsPETe(Xp,r=1.25)

dom.greedy(inc.mat)
IndUBdom(inc.mat,2) #try also dom.exact(inc.mat)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatPEtri}}, \code{\link{IncMatPE}} and \code{\link{IncMatCSTe}}
}
\author{
Elvan Ceyhan
}
