% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pcaBootPlot.R
\name{pcaBootPlot}
\alias{pcaBootPlot}
\title{Create 2D PCA Plots with Bootstrapping}
\usage{
pcaBootPlot(data = NULL, groups = NULL, min.value = 1,
  all.min.value = FALSE, num.boot.samples = 100, log2.transform = TRUE,
  pdf.filename = NULL, pdf.width = 6, pdf.height = 6,
  draw.legend = FALSE, legend.names = NULL, legend.x = NULL,
  legend.y = NULL, transparency = 77, min.x = NULL, max.x = NULL,
  min.y = NULL, max.y = NULL, correct.inversions = TRUE)
}
\arguments{
\item{data}{A data.frame where the first column is named "ID" and contains IDs
for each item measured. Measurements for each sample are in subsequent columns.}

\item{groups}{The default value is \strong{\code{NULL}}.\cr\cr
If you want use different colors
and shapes to deliniate the samples into groups, you can specify the grouping
with this argument. Currently there is a limit of 9 different groups.\cr\cr
For example, if you have three consecutive columns of
"untreated" samples followed by three consecutive columns of "treated" samples,
you can set this argument to c(1,1,1,2,2,2), and the untreated samples will be
red circles and the treated samples will be blue triangles.}

\item{min.value}{The default value is \strong{1}.\cr\cr
This allows you to filter out rows (entries) that will not conribute
to the PCA. For example, if you are performing PCA on RNA-seq data, you
may wish to filter out genes with less than 1 read per sample, 1 read per
group or 1 read overall. If you set \code{all.min.value} to \code{TRUE},
it will filter entries where at least one sample has less than
\code{min.value}. If you do not set \code{all.min.value} to \code{TRUE},
then filtering will be performed by group if \code{groups} are specified.
In this case, an entry will be filtered out if one or more groups have
less than \code{min.value}.\cr\cr
If \code{groups} are not specified, then only entries where all samples
have less than \code{min.value} will be removed from the analysis.\cr\cr
\code{groups} will also effect filtering based on \code{min.value}.
See that part of the documentation for details.}

\item{all.min.value}{This parameter, set to either \code{TRUE} or \code{FALSE},
affects
\code{min.value}. See the documentation for \code{min.value} for more
details.}

\item{num.boot.samples}{The default value is \strong{100}. The number of bootstrap
iterations to be performed.}

\item{log2.transform}{The default value is \strong{\code{TRUE}}. Should the data be log2
transformed or not?}

\item{pdf.filename}{If you wish to save the the graph as a PDF, you may use
this argument to specify the filename.}

\item{pdf.width}{If you specify a value for \code{pdf.filename}, you can specify
a width for the saved graph. The default value is 6 inches.}

\item{pdf.height}{If you specify a value for \code{pdf.filename}, you can
specify a height for the saved graph. The default value is 6 inches.}

\item{draw.legend}{The default value is \strong{\code{FALSE}}. Should there be a legend
in the graph?}

\item{legend.names}{If \code{draw.legend} is \code{TRUE}, you can specify the
names of the groups listed in the legend.}

\item{legend.x,legend.y}{If \code{draw.legend} is \code{TRUE}, you can specify
the x and y axis coordinate for its top left corner.}

\item{transparency}{The default value is \strong{77}. This allow you to set how
transparent the bootstrapped symbols are in the graph. Values range from 00
to FF.}

\item{min.x,min.y,max.x,max.y}{By default, pcaBootPlot automatically
determines limits for the
x and y axes. Use this option to override this behavior.}

\item{correct.inversions}{The default value is \strong{\code{TRUE}}. Some of the
boostrapped PCAs may have their axes inverted. pcaBootPlot can try to correct
for this by ensuring that the PCA loading values are positively correlated
with the orginal dataset.}
}
\description{
pcaBootPlot draws a 2D PCA plot using the first 2 principal components using
  the original and bootstrapped data to give some sense of variability.
}
\examples{
sample1=rnorm(n=100, mean=100, sd=10)
sample2=jitter(sample1, factor=10, amount=10)
sample3=rnorm(n=100, mean=100, sd=10)

data <- data.frame(ID=c(1:100), sample1, sample2, sample3)

pcaBootPlot(data, log2.transform = FALSE)
}

