% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generateItem}
\alias{generateItem}
\title{Generate paired comparison data for one or more items given
absolute latent scores}
\usage{
generateItem(df, theta, th = 0.5, name, ..., scale = 1, alpha = 1)
}
\arguments{
\item{df}{a data frame with pairs of vertices given in columns \code{pa1} and \code{pa2}, and item response data in other columns}

\item{theta}{a vector or matrix of absolute latent scores. See details below.}

\item{th}{a vector of thresholds}

\item{name}{a vector of item names}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{scale}{a vector of scaling constants}

\item{alpha}{a vector of item discriminations}
}
\value{
The given data.frame \code{df} with additional columns for each item.
}
\description{
To add a single item, \code{theta} should be a vector of latent
scores. To add multiple items at a time, \code{theta} should be a
matrix with one item in each column. Item names can be given as
the colnames of \code{theta}.

The interpretation of \code{theta} depends on the context where the
data were generated. For example, in chess, \code{theta} represents
unobserved chess skill that is partially revealed by match
outcomes.

The graph can be regarded as undirected, but data are generated
relative to the order of vertices within each row. Vertices do not
commute. For example, a \code{-1} for vertices \sQuote{a} and
\sQuote{b} is the same as \code{1} for vertices \sQuote{b} and
\sQuote{a}.
}
\section{Response model}{


See \link{cmp_probs} for details.
}

\examples{
df <- roundRobinGraph(letters[1:5], 40)
df <- generateItem(df)
}
\seealso{
Other item generators: 
\code{\link{generateCovItems}()},
\code{\link{generateFactorItems}()},
\code{\link{generateSingleFactorItems}()}
}
\concept{item generators}
