% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_delivery_source}
\alias{cloudwatchlogs_put_delivery_source}
\title{Creates or updates a logical delivery source}
\usage{
cloudwatchlogs_put_delivery_source(name, resourceArn, logType, tags = NULL)
}
\arguments{
\item{name}{[required] A name for this delivery source. This name must be unique for all
delivery sources in your account.}

\item{resourceArn}{[required] The ARN of the Amazon Web Services resource that is generating and
sending logs. For example,
\verb{arn:aws:workmail:us-east-1:123456789012:organization/m-1234EXAMPLEabcd1234abcd1234abcd1234}}

\item{logType}{[required] Defines the type of log that the source is sending. For valid values for
this parameter, see the documentation for the source service.}

\item{tags}{An optional list of key-value pairs to associate with the resource.

For more information about tagging, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}}
}
\description{
Creates or updates a logical \emph{delivery source}. A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3, or Kinesis Data Firehose.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_delivery_source/} for full documentation.
}
\keyword{internal}
