% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_list_incident_records}
\alias{ssmincidents_list_incident_records}
\title{Lists all incident records in your account}
\usage{
ssmincidents_list_incident_records(
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{filters}{Filters the list of incident records you want to search through. You can
filter on the following keys:
\itemize{
\item \code{creationTime}
\item \code{impact}
\item \code{status}
\item \code{createdBy}
}

Note the following when when you use Filters:
\itemize{
\item If you don't specify a Filter, the response includes all incident
records.
\item If you specify more than one filter in a single request, the
response returns incident records that match all filters.
\item If you specify a filter with more than one value, the response
returns incident records that match any of the values provided.
}}

\item{maxResults}{The maximum number of results per page.}

\item{nextToken}{The pagination token to continue to the next page of results.}
}
\description{
Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the incident record you want to update.

See \url{https://www.paws-r-sdk.com/docs/ssmincidents_list_incident_records/} for full documentation.
}
\keyword{internal}
