% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_associate_kms_key}
\alias{cloudwatchlogs_associate_kms_key}
\title{Associates the specified KMS key with the specified log group}
\usage{
cloudwatchlogs_associate_kms_key(logGroupName, kmsKeyId)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{kmsKeyId}{[required] The Amazon Resource Name (ARN) of the KMS key to use when encrypting log
data. This must be a symmetric KMS key. For more information, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kms}{Amazon Resource Names}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using Symmetric and Asymmetric Keys}.}
}
\description{
Associates the specified KMS key with the specified log group.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_associate_kms_key/} for full documentation.
}
\keyword{internal}
