% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_inventory_schema}
\alias{ssm_get_inventory_schema}
\title{Return a list of inventory type names for the account, or return a list
of attribute names for a specific Inventory item type}
\usage{
ssm_get_inventory_schema(
  TypeName = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  Aggregator = NULL,
  SubType = NULL
)
}
\arguments{
\item{TypeName}{The type of inventory item to return.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{Aggregator}{Returns inventory schemas that support aggregation. For example, this
call returns the \code{AWS:InstanceInformation} type, because it supports
aggregation based on the \code{PlatformName}, \code{PlatformType}, and
\code{PlatformVersion} attributes.}

\item{SubType}{Returns the sub-type schema for a specified inventory type.}
}
\description{
Return a list of inventory type names for the account, or return a list of attribute names for a specific Inventory item type.

See \url{https://paws-r.github.io/docs/ssm/get_inventory_schema.html} for full documentation.
}
\keyword{internal}
